/*
 micej1.java

 copyright 2001, 2002, Alan H. Clifford.

 This program is free software; you can redistribute it and/or modify it
 under the terms of the GNU General Public License as published by the Free
 Software Foundation; either version 2 of the License, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful, but
 WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 for more details.

 You should have received a copy of the GNU General Public License along
 with this program; if not, write to the Free Software Foundation, Inc., 59
 Temple Place, Suite 330, Boston, MA 02111-1307 USA


 Alan Clifford can be contacted at mice@clifford.ac

 Latest version at http://www.clifford.ac

 $Id: micej1.java,v 1.33 2002/06/24 00:14:54 alan Exp $

 $Name: release4_2 $

 */

import java.net.*;
import java.io.*;
import java.util.Vector;
import java.awt.*;
import java.awt.event.*;

public class micej1 {
    //static int port = 1953;
    static int port = 5022;
    // static String host = "192.168.0.1";
    static String host = "localhost";
    static String micemode = "graphic";  // eg "console" or "graphic" or "both"
    static boolean chooser = true;
    static Socket miceserver = null;
    static BufferedReader bufferedfromserver;
    static PrintWriter printtoserver;
    public static void main(String args[]) {
        try {
            // ignore out of bounds errors
            for (int argctr = 0, optionctr = 0, nonoptionctr = 0; argctr < args.length; ++argctr) {
                // System.out.println("a " + args[argctr]);
                if (args[argctr].startsWith("--")) {
                    if (args[argctr].equals("--nochooser")) {
                        chooser = false;
                    }
                    else if (((argctr + 1) < args.length)
                        && (args[argctr].equals("--mode"))) {
                        micemode = args[++argctr];
                    }
                    else ++argctr;
                    // if (argctr < args.length) System.out.println("ao " + args[argctr]);
                }
                else {
                    // if it parses as an int, put it in port
                    // otherwise put it in host
                    try {
                        port = Integer.parseInt(args[argctr]);
                    }
                    catch(NumberFormatException e) {
                        // System.out.println("Parse port " + e);  // temporary
                        host = args[argctr];
                    }
                    ++nonoptionctr;

                }
            }
        }
        catch(ArrayIndexOutOfBoundsException e) {};


        new miceStatus(micemode); // set up statics

        // doConnect();

        micej1 newmicej1 = new micej1();

        // Windows withj2re-1_4_0_01 has multiple button images on startup
        // when nochooser is used

        if (miceStatus.getMiceGraphicMode() && chooser) {
            // need window to choose host and port
            // run doConnect when OK clicked
            new chooserWindow(host, port);
        }
        else {
            // newmicej1.doConnect();
            micej1.doConnect();
        }

    }

    static void doConnect()
    {
        try {
            miceserver = new Socket(host, port);
            bufferedfromserver = new BufferedReader(new InputStreamReader(miceserver.getInputStream()));
            printtoserver = new PrintWriter(miceserver.getOutputStream(), true);
        }
        catch(UnknownHostException e) {
            miceStatus.showError("Host not found " + e);
            return;
            // System.exit(1);
        }
        catch(IOException e) {
            miceStatus.showError("Connection to host error " + e);
            // System.exit(1);
            return;
        }

        // for debugging
        // printtoserver.println("OS name: " + miceStatus.getOsName());


        if (!miceStatus.getOsName().equalsIgnoreCase("epoc")) {
            // This is the bit the psion doesn't like.
            try {
                // for debugging
                // if (miceStatus.getMiceConsoleMode()) {
                // System.out.println("linger " + Integer.toString(miceserver.getSoLinger()));
                // }

                if (-1 == miceserver.getSoLinger()) {
                    miceserver.setSoLinger(true, 5); // 5 seconds

                    // for debugging
                    // if (miceStatus.getMiceConsoleMode()) {
                    //     System.out.println("linger " + String.valueOf(miceserver.getSoLinger()));
                    // }
                    // printtoserver.println("linger " + String.valueOf(miceserver.getSoLinger()));
                }
            }
            catch(SocketException se) {
                // miceStatus.showError("Set linger error " + se);
                // do nothing
            }
        }



        // run the console input early, exit if null is received
        if (miceStatus.getMiceConsoleMode()) {
            new Thread(new Userinput(printtoserver)).start();  // console input
        }


        // start the window first
        if (miceStatus.getMiceGraphicMode()) {
            new Userwindow(printtoserver);
        }


        Micedata micedata = new Micedata(bufferedfromserver);
        new Thread(micedata).start();
        new Thread(new Putmicedata(micedata)).start();
        // get server name
        // Not required, server sends it automatically when client starts
        // yes it is, the windows client doesn't get it. Too slow running classes?
        printtoserver.println("\002servername\003");

        // Ask server for isps
        printtoserver.println("isps");

        // Ask server for status
        // temporarily disabled for development
        printtoserver.println("status");

        /*
        String myProperty = System.getProperty("os.name");
        // System.out.println(myProperty);
        printtoserver.println("os.name: " + myProperty);
        myProperty = System.getProperty("os.arch");
        // System.out.println(myProperty);
        printtoserver.println("os.arch: " + myProperty);
        myProperty = System.getProperty("os.version");
        // System.out.println(myProperty);
        printtoserver.println("os.version: " + myProperty);
        myProperty = System.getProperty("user.dir");
        printtoserver.println("user.dir: " + myProperty);
        myProperty = System.getProperty("user.home");
        printtoserver.println("user.home: " + myProperty);
        myProperty = System.getProperty("java.ext.dir");
        printtoserver.println("java,ext,dirs: " + myProperty);
        */


        // System.gc();


    }

    micej1() {
        if (miceStatus.getMiceConsoleMode()) {
            System.out.println("Mundungus Internet Connection Enhancer java client");
            System.out.println("($Revision: 1.33 $)");
            System.out.println("($Name: release4_2 $)");
        }
    }


}



class Micedata implements Runnable {
    static final int MAXQUEUE = 25;
    static Vector servermessages = new Vector();
    BufferedReader bufferedfromserver;

    Micedata(BufferedReader brf) {
        bufferedfromserver = brf;
    }

    public void run() {
        try {
            while (true) {
                // if (!bufferedfromserver.exists()) System.exit(2);
                String message = (String)bufferedfromserver.readLine();
                if (message == null) {
                    if (miceStatus.getMiceConsoleMode())
                        System.out.println("Bye bye");
                    System.exit(2);
                }
                getdata(message);
                // Thread.sleep(10);
            }
        }


        catch(IOException e) {
            miceStatus.showError("IO exception:  " + e);
            // System.out.println("What?");
            System.exit(1);
        }


        catch(InterruptedException e) {
            miceStatus.showError("Interrupt exception:  " + e);
            // System.out.println("What?");
            System.exit(1);
        }


    }

    private synchronized void getdata(String message) throws InterruptedException, IOException  {
        while (servermessages.size() == MAXQUEUE) {
            // System.out.println("getdata.wait.............\n");
            notifyAll();
            wait();
        }

        servermessages.addElement(message);

        notifyAll();
    }

    public synchronized String putdata() throws InterruptedException {
        String message = null;
        notifyAll();
        while (servermessages.size() == 0) {
            // System.out.println("putdata.wait.............\n");
            notifyAll();
            wait();
        }

        message = (String) servermessages.firstElement();
        // System.out.println("++ " + message);
        servermessages.removeElement(message);
        // servermessages.removeElement(servermessages.firstElement());
        return message;
    }
}


class Putmicedata implements Runnable {
    Micedata micedata;
    final static String STARTOFSTATUS = "0090";
    final static String ENDOFSTATUS = "0990";
    final static String CLIENTCOUNT = "0101";
    final static String CONNECTREQUESTS = "0102";
    final static String RECONNECTREQUESTS = "0103";
    final static String CONNECTORRUN = "0060";
    final static String CONNECTORNOTRUN = "0960";
    final static String LINEON = "0080";
    final static String LINEOFF = "0980";
    final static String INFOMSG = "0170";
    final static String MYCONNECT = "0052"; // Current client connect request
    final static String MYRECONNECT = "0053"; // Current client reconnect request
    final static String MYNOCONNECT = "0952"; // Current client not requested connection/reconnection
    final static String CURRENTISPSHORT = "0030";
    final static String CURRENTISPLONG = "0031";


    // ad hoc status 1???
    final static String CONNECTORSTART = "1060";  // Connector program started
    final static String CONNECTORNOSTART = "1960";  // Connector program not started
    final static String CONNECTORALREADY = "1061";  // Connector program already running
    final static String LINEON2 = "1080";  // on line
    final static String LINEOFF2 = "1980";  // off line
    final static String INFOMSG2 = "1170";
    final static String CURRENTISPSHORT2 = "1030";
    final static String CURRENTISPLONG2 = "1031";

    // instructions from client 2???
    final static String MYCONNECTREQ = "2052"; // Current client connect request
    final static String MYRECONNECTREQ = "2053"; // Current client reconnect request
    final static String MYNOCONNECTREQ = "2952"; // Current client not requested connection/reconnection
    final static String MYDISCONNECTREQ = "2953"; // Current client disconnect requested
    final static String AUTORECONNECT = "2054"; // Automatic reconnect request
    final static String MYCONNECTALREADY = "2055"; // Current client connect already requested
    final static String MYRECONNECTALREADY = "2056"; // Current client reconnect already requested
    final static String GLOBALDISCONNECTREQ  ="2954";  // Global disconnection requested

    // isp data 3???
    final static String STARTOFISP = "3090";
    final static String ENDOFISP = "3990";
    final static String ISPDATA = "3000";

    // Are you there
    final static String AYTGENERAL = "4000";
    final static String AYTCONSOLE = "4001";
    final static String AYTJAVA =    "4002";
    final static String AYTTELNET =  "4003";


    // other
    final static String SERVERNAMEMSG = "1200";  // Server name from server at client startup


    // final static String INFORMATIONCODE2 = "7016";
    static String servername = "Unknown";
    static String [] isconnected = {"", "", ""}; // message, current, previous
    static String [] clientcount = {"", "", ""}; // message, current count, previous count
    static String [] isonline = {"", "", ""}; // message, current, previous
    static String [] information = {"", "", ""}; // message, current, previous
    static String [] connectrequests = {"", ""};
    static String [] reconnectrequests = {"", ""};
    static String myconnect = "";  // This client connect request status
    static Color [] connectorbg = {Color.white, Color.white, Color.orange};
    static Color [] linestatusbg = {Color.lightGray, Color.lightGray, Color.red, Color.green};
    static Color [] informationbg = {Color.lightGray, Color.lightGray, Color.white};
    static Color [] myconnectbg = {Color.white, Color.white, Color.yellow, Color.orange};
    // isps.  short name, long name
    static String ispData [][] = {{" ", " "}, {" ", " "}};
    static String ispShort = "testshort";
    static String ispLong = "test long";

    Putmicedata(Micedata d) {
        micedata = d;
    }

    public void run () {
        try {
            boolean micegraphicstatus = miceStatus.getMiceGraphicMode();
            boolean miceconsolestatus = miceStatus.getMiceConsoleMode();

            while (true) {
                String message = micedata.putdata();
                // check for AYT
                if ((message.startsWith(AYTGENERAL, 0)) ||
                    (message.startsWith(AYTJAVA, 0)))
                    micej1.printtoserver.println("\002JAVACLIENTAYT\003");

                if (miceconsolestatus) {
                    System.out.println(message);
                }
                if (micegraphicstatus) {
                    docommandcode(message);
                }
            }
        }
        catch(InterruptedException e) {
            miceStatus.showError("Interrupt exception:  " + e);
            // System.out.println("What?");
        }

    }



    private void docommandcode(String s) {
        if (s.length() > 4) {
            // String codeS = s.substring(0, 4);
            // System.out.println("substring " + codeS);

            // at start of status report from server, zero the fields
            if (s.startsWith(STARTOFSTATUS)) {
                clientcount[0] = "Client count:  ";
                connectrequests[0] = "Connect requests:";
                reconnectrequests[0] = "Reconnect requests:";
                isconnected[0] = "Connector program:  ";
                isonline[0] = "Line status:  ";
                information[0] = "Information:  ";
                myconnect = "This client:";
                connectorbg[0] = connectorbg[1];
                linestatusbg[0] = linestatusbg[1];
                informationbg[0] = informationbg[1];
                myconnectbg[0] = myconnectbg[1];
                ispShort = " ";
                ispLong = " ";
            }
            else if (s.startsWith(ENDOFSTATUS)) {
                Userwindow.setccfield(clientcount[0]);
                Userwindow.setcreqfield(connectrequests[0]);
                Userwindow.setrcreqfield(reconnectrequests[0]);
                Userwindow.setcpfield(isconnected[0], connectorbg[0]);
                Userwindow.setlinestatusfield(isonline[0], linestatusbg[0]);
                Userwindow.setinformationfield(information[0], informationbg[0]);
                Userwindow.setmyconnectfield(myconnect, myconnectbg[0]);
                Userwindow.setCurrentIspShort(ispShort);
                Userwindow.setCurrentIspLong(ispLong);
                // Userwindow.quitbutton.invalidate();
                // Userwindow.commandpanel.invalidate();
                // Userwindow.isppanel.invalidate();
                // Userwindow.micef.pack();
            }


            else if (s.startsWith(CLIENTCOUNT, 0)) {
                // status report from server, number of clients
                int offset;
                if (-1 != (offset = s.indexOf(": "))) {
                    clientcount[1] = s.substring(offset + 1).trim();
                    if (Integer.valueOf(clientcount[1]).intValue() == 1)
                        clientcount[0] = "1 client";
                    else
                        clientcount[0] = clientcount[1] + " clients";
                }
            }

            else if (s.startsWith(CONNECTREQUESTS, 0)) {
                // status report from server
                int offset;
                if (-1 != (offset = s.indexOf(": "))) {
                    connectrequests[1] = s.substring(offset + 1).trim();
                    if (Integer.valueOf(connectrequests[1]).intValue() == 1)
                        connectrequests[0] = "1 connect request";
                    else
                        connectrequests[0] = connectrequests[1] + " connect requests";
                }
            }

            else if (s.startsWith(RECONNECTREQUESTS, 0)) {
                // status report from server
                int offset;
                if (-1 != (offset = s.indexOf(": "))) {
                    reconnectrequests[1] = s.substring(offset + 1).trim();
                    if (Integer.valueOf(reconnectrequests[1]).intValue() == 1)
                        reconnectrequests[0] = "1 reconnect request";
                    else
                        reconnectrequests[0] = reconnectrequests[1] + " reconnect requests";
                }
            }

            else if (s.startsWith(CONNECTORNOTRUN, 0)) {
                // status report from server
                isconnected[0] = "Connector program is NOT running";
                connectorbg[0] = connectorbg[1];
            }

            else if (s.startsWith(CONNECTORRUN, 0)) {
                // status report from server
                isconnected[0] = "Connector program is running";
                connectorbg[0] = connectorbg[2];
            }

            else if (s.startsWith(LINEON, 0)) {
                // line status report from server, on or off line
                isonline[0] = "Online";
                linestatusbg[0] = linestatusbg[3];
            }

            else if (s.startsWith(LINEOFF, 0)) {
                // line status report from server, on or off line
                isonline[0] = "Offline";
                linestatusbg[0] = linestatusbg[2];
            }

            else if (s.startsWith(INFOMSG, 0)) {
                // status report from server, information string
                int offset;
                // parse for information
                if (-1 != (offset = s.indexOf(": "))) {
                    information[1] = s.substring(offset + 1).trim();
                    information[0] = information[1];
                    informationbg[0] = informationbg[2];
                }
            }

            else if (s.startsWith(MYCONNECT, 0)) {
                // line status report from server, on or off line
                myconnect = "This client has requested connection";
                myconnectbg[0] = myconnectbg[2];
            }

            else if (s.startsWith(MYRECONNECT, 0)) {
                // line status report from server, on or off line
                myconnect = "This client has requested reconnection";
                myconnectbg[0] = myconnectbg[3];
            }

            else if (s.startsWith(MYNOCONNECT, 0)) {
                // line status report from server, on or off line
                myconnect = "This client has not requested connection";
                myconnectbg[0] = myconnectbg[1];
            }
            // current isp shortname
            else if (s.startsWith(CURRENTISPSHORT)) {
                // isp shortname
                int offset;
                if (-1 != (offset = s.indexOf(": "))) {
                    ispShort = s.substring(offset + 1).trim();
                    /*
                     if (miceStatus.getMiceConsoleMode()) {
                     System.out.println("Status:  This is the isp shortname: <" + ispShort + ">");
                     }
                     */
                }
            }

            // current isp longname
            else if (s.startsWith(CURRENTISPLONG)) {
                int offset;
                if (-1 != (offset = s.indexOf(" "))) {
                    ispLong = s.substring(offset).trim();
                    /*
                     if (miceStatus.getMiceConsoleMode()) {
                     System.out.println("Status:  This is the isp longname: <" + ispLong + ">");
                     }
                     */
                }
            }


            // The following are ad-hoc status lines, so use invokeLater immediately

            else if (s.startsWith(CONNECTORSTART, 0)) {
                isconnected[0] = "Connector program has started";
                connectorbg[0] = connectorbg[2];
                // EventQueue.invokeLater(Transferconnector);
                Userwindow.setcpfield(isconnected[0], connectorbg[0]);
            }

            else if (s.startsWith(CONNECTORALREADY, 0)) {
                isconnected[0] = "Connector program already running";
                connectorbg[0] = connectorbg[2];
                // EventQueue.invokeLater(Transferconnector);
                Userwindow.setcpfield(isconnected[0], connectorbg[0]);
            }

            else if (s.startsWith(CONNECTORNOSTART, 0)) {
                isconnected[0] = "Connector program failed to start";
                connectorbg[0] = connectorbg[1];
                // EventQueue.invokeLater(Transferconnector);
                Userwindow.setcpfield(isconnected[0], connectorbg[0]);
            }

            else if (s.startsWith(LINEON2, 0)) {
                isonline[0] = "Online";
                linestatusbg[0] = linestatusbg[3];
                // EventQueue.invokeLater(Transferonline);
                Userwindow.setlinestatusfield(isonline[0], linestatusbg[0]);
            }
            else if (s.startsWith(LINEOFF2, 0)) {
                // line status report from server, on or off line
                isonline[0] = "Offline";
                linestatusbg[0] = linestatusbg[2];
                // EventQueue.invokeLater(Transferonline);
                Userwindow.setlinestatusfield(isonline[0], linestatusbg[0]);
            }

            else if (s.startsWith(INFOMSG2, 0)) {
                // information string
                int offset;
                // parse for information
                if (-1 != (offset = s.indexOf(": "))) {
                    information[1] = s.substring(offset + 1).trim();
                    information[0] = information[1];
                    informationbg[0] = informationbg[2];
                    // EventQueue.invokeLater(Transferinformation);
                    Userwindow.setinformationfield(information[0], informationbg[0]);
                }
            }


            // The following are results of client requests, so use invokeLater immediately

            else if (s.startsWith(MYCONNECTREQ, 0)) {
                // line status report from server, on or off line
                myconnect = "This client has requested connection";
                myconnectbg[0] = myconnectbg[2];
                // EventQueue.invokeLater(Transfermyconnect);
                Userwindow.setmyconnectfield(myconnect, myconnectbg[0]);
                // Userwindow.micef.pack();
            }

            else if (s.startsWith(MYCONNECTALREADY, 0)) {
                // line status report from server, on or off line
                myconnect = "This client has already requested connection";
                myconnectbg[0] = myconnectbg[2];
                // EventQueue.invokeLater(Transfermyconnect);
                Userwindow.setmyconnectfield(myconnect, myconnectbg[0]);
                // Userwindow.micef.pack();
            }

            else if (s.startsWith(MYRECONNECTREQ, 0)) {
                // line status report from server, on or off line
                myconnect = "This client has requested reconnection";
                myconnectbg[0] = myconnectbg[3];
                // EventQueue.invokeLater(Transfermyconnect);
                Userwindow.setmyconnectfield(myconnect, myconnectbg[0]);
                // Userwindow.micef.pack();
            }

            else if (s.startsWith(MYRECONNECTALREADY, 0)) {
                // line status report from server, on or off line
                myconnect = "This client has already requested reconnection";
                myconnectbg[0] = myconnectbg[3];
                // EventQueue.invokeLater(Transfermyconnect);
                Userwindow.setmyconnectfield(myconnect, myconnectbg[0]);
                // Userwindow.micef.pack();
            }

            else if (s.startsWith(AUTORECONNECT, 0)) {
                // line status report from server, on or off line
                myconnect = "Automatic reconnection";
                myconnectbg[0] = myconnectbg[3];
                // EventQueue.invokeLater(Transfermyconnect);
                Userwindow.setmyconnectfield(myconnect, myconnectbg[0]);
                // Userwindow.micef.pack();
            }

            else if (s.startsWith(MYDISCONNECTREQ, 0)) {
                // line status report from server, on or off line
                myconnect = "This Client has requested disconnection";
                myconnectbg[0] = myconnectbg[1];
                // EventQueue.invokeLater(Transfermyconnect);
                Userwindow.setmyconnectfield(myconnect, myconnectbg[0]);
                // Userwindow.micef.pack();
            }

            else if (s.startsWith(MYNOCONNECTREQ, 0)) {
                // line status report from server, on or off line
                myconnect = "This Client has not requested connection / reconnection";
                myconnectbg[0] = myconnectbg[1];
                // EventQueue.invokeLater(Transfermyconnect);
                Userwindow.setmyconnectfield(myconnect, myconnectbg[0]);
                // Userwindow.micef.pack();
            }

            else if (s.startsWith(GLOBALDISCONNECTREQ, 0)) {
                // line status report from server, on or off line
                myconnect = "Global disconnection requested";
                myconnectbg[0] = myconnectbg[1];
                // EventQueue.invokeLater(Transfermyconnect);
                Userwindow.setmyconnectfield(myconnect, myconnectbg[0]);
                // Userwindow.micef.pack();
            }

            // other
            else if (s.startsWith(SERVERNAMEMSG, 0)) {
                // server name at client startup
                int offset;
                // parse for information
                if (-1 != (offset = s.indexOf(": "))) {
                    servername = "Mice server is " + s.substring(offset + 1).trim();
                    // EventQueue.invokeLater(Transferservername);
                    Userwindow.setservernamefield(servername);
                    // System.out.println("This is the server name: " + servername);
                }
            }

            // current isp shortname
            else if (s.startsWith(CURRENTISPSHORT2)) {
                // isp shortname
                int offset;
                // parse for information
                if (-1 != (offset = s.indexOf(": "))) {
                    ispShort = s.substring(offset + 1).trim();
                    /*
                     if (miceStatus.getMiceConsoleMode()) {
                     System.out.println("This is the isp shortname: <" + ispShort + ">");
                     }
                     */
                    // EventQueue.invokeLater(TransferCurrentIspShort);
                    Userwindow.setCurrentIspShort(ispShort);
                }
            }

            // current isp longname
            else if (s.startsWith(CURRENTISPLONG2)) {
                int offset;
                if (-1 != (offset = s.indexOf(" "))) {
                    ispLong = s.substring(offset).trim();
                    /*
                     if (miceStatus.getMiceConsoleMode()) {
                     System.out.println("This is the isp longname: <" + ispLong + ">");
                     }
                     */
                    // EventQueue.invokeLater(TransferCurrentIspLong);
                    Userwindow.setCurrentIspLong(ispLong);
                }
            }


            // isp data
            // at start of isp list, create new array
            else if (s.startsWith(STARTOFISP)) {
                int offset1, offset2;
                ispData = new String [1][2];
                // discard the data and put in new title
                ispData[0][0] = "";
                ispData[0][1] = "Choose ISP";
            }

            else if (s.startsWith(ISPDATA)) {
                int offset1, offset2, arrayLength;
                // parse the title string
                offset1 = s.indexOf(" ");
                offset2 = s.indexOf(": ");
                arrayLength = ispData.length;
                if ((-1 != offset1) && (-1 != offset2)) {
                    // create a new array
                    String ispTemp[][] = new String [arrayLength + 1][2];
                    System.arraycopy(ispData, 0, ispTemp, 0, arrayLength);
                    ispData = ispTemp;
                    ispData[arrayLength][0] = s.substring(offset1, offset2).trim();
                    ispData[arrayLength][1] = s.substring(offset2 + 1).trim();
                    /*
                     if (miceStatus.getMiceConsoleMode()) {
                     System.out.println("isp is:  <" + ispData[arrayLength][0] + "><"
                     + ispData[arrayLength][1] + ">");
                     System.out.println("isp length:  " + ispData.length);
                     }
                     */
                }
            }
            else if (s.startsWith(ENDOFISP)) {
                // at end of isps from server, update the display
                // EventQueue.invokeLater(TransferIsps);
                Userwindow.ResetIspChooser(ispData);
            }
            // psion resize problem
            // Userwindow.clientspanel.setSize(Userwindow.clientspanel.getMinimumSize());
            // Userwindow.micef.repaint();
            Userwindow.micef.pack();


            // Userwindow.micef.validate();


        }

    }
}


class Userinput implements Runnable {
    static BufferedReader userdata = new BufferedReader(new InputStreamReader(System.in));
    PrintWriter printtoserver;

    Userinput(PrintWriter pw) {
        printtoserver = pw;

    }

    public void run() {
        String userline;
        try {
            while(true) {
                // String userline = userdata.readLine();
                if (null != (userline = userdata.readLine())) {
                    // test for null
                    // continuous null if run from kde with --mode console and no console
                    printtoserver.println(userline);
                }
                else {
                    printtoserver.println("no stdin");
                    System.exit(5);
                }
            }
        }
        catch(IOException e) {
            // miceStatus.showError("IO exception:  " + e);
            printtoserver.println("no stdin probably");
            System.exit(5);
            // System.out.println("User input" + e);
        }
    }
}


// class Userwindow extends Component implements ItemListener {
class Userwindow implements ItemListener {
    static Panel commandpanel = new Panel();

    static PrintWriter printtoserver;

    static Panel infopanel = new Panel();
    static Panel clientspanel = new Panel();
    static Panel isppanel = new Panel();
    static TextField servernamefield = new TextField();
    // static Label servernamefield = new Label();
    static TextField clientcountfield = new TextField();
    // static Label clientcountfield = new Label();
    static TextField connectrequestsfield = new TextField();
    // static Label connectrequestsfield = new Label();
    static TextField reconnectrequestsfield = new TextField();
    // static Label reconnectrequestsfield = new Label();
    static TextField connectorprogramfield = new TextField();
    // static Label connectorprogramfield = new Label();
    static TextField linestatusfield = new TextField();
    // static Label linestatusfield = new Label();
    static TextField informationfield = new TextField();
    // static Label informationfield = new Label();
    static TextField myconnectfield = new TextField();
    // static Label myconnectfield = new Label();
    static Button connectbutton = new Button("Connect");
    static Button reconnectbutton = new Button("Reconnect");
    static Button disconnectbutton = new Button("Disconnect");
    static Button bangbutton = new Button("BANG");
    static Button statusbutton = new Button("Status");
    static Button quitbutton = new Button("Quit");
    static Frame micef = new Frame("Micej1 Client $Revision: 1.33 $");
    static String currentIspShort = "";
    static String currentIspLong = "";
    static String ispData [][] = {{" ", " "}, {" ", " "}};



    // ISP chooser
    static Choice ispChooser = new Choice();

    myActionListener mal = new myActionListener();
    // static ActionListener mal = new myActionListener();
    // myWindowListener mwl = new myWindowListener();

    Userwindow(PrintWriter pw) {
        printtoserver = pw;

        // micef.addWindowListener(mwl);

        // quit on window close
        micef.addWindowListener(new WindowAdapter()
                                {
                                    public void windowOpened(WindowEvent we) {
                                        // ispChooser.requestFocus();
                                        whichFocus();
                                    }
                                    public void windowActivated(WindowEvent we) {
                                        //if (ispChooser.isEnabled())
                                        //    ispChooser.requestFocus();
                                        //else
                                        //    statusbutton.requestFocus();
                                        whichFocus();
                                    }
                                    public void windowClosing(WindowEvent we)
                                    {
                                        System.exit(0);
                                    }

                                    void whichFocus() {
                                        if (ispChooser.isEnabled())
                                            ispChooser.requestFocus();
                                        else
                                            statusbutton.requestFocus();
                                    }
                                }
                               );
        isppanel.add(connectbutton);
        connectbutton.setActionCommand("connect");
        connectbutton.addActionListener(mal);

        isppanel.add(reconnectbutton);
        reconnectbutton.setActionCommand("reconnect");
        reconnectbutton.addActionListener(mal);

        // don't enable connection buttons until an ISP has been selected
        disableConnect();  // disable the connection buttons if no ISP


        commandpanel.add(disconnectbutton);
        disconnectbutton.setActionCommand("disconnect");
        disconnectbutton.addActionListener(mal);
        disconnectbutton.setBackground(Color.blue);
        disconnectbutton.setForeground(Color.white);

        commandpanel.add(statusbutton);
        statusbutton.setActionCommand("status");
        statusbutton.addActionListener(mal);
        statusbutton.setBackground(Color.blue);
        statusbutton.setForeground(Color.white);

        commandpanel.add(bangbutton);
        bangbutton.setActionCommand("BANG");
        bangbutton.addActionListener(mal);
        bangbutton.setBackground(Color.red);
        bangbutton.setForeground(Color.white);

        commandpanel.add(quitbutton);
        quitbutton.setActionCommand("quit");
        quitbutton.addActionListener(mal);
        quitbutton.setBackground(Color.red);
        quitbutton.setForeground(Color.white);

        // commandpanel.setLayout(new GridLayout(1,4));
        commandpanel.setLayout(new FlowLayout(FlowLayout.CENTER, 5,1));

        commandpanel.setBackground(Color.cyan);


        // ISP chooser
        ispChooser.add("Get ISPs");
        ispChooser.setBackground(Color.blue);
        ispChooser.setForeground(Color.white);
        ispChooser.select(0);
        ispChooser.addItemListener(this);
        isppanel.add(ispChooser, 0);

        // isppanel.setLayout(new GridLayout(1,3));
        isppanel.setLayout(new FlowLayout(FlowLayout.CENTER, 5,1));

        isppanel.setBackground(Color.cyan);


        // text fields
        servernamefield.setText("Server name:  " + "unknown");
        servernamefield.setEditable(false);
        // text fields


        clientcountfield.setText("Client count:  " + "unknown");
        clientcountfield.setEditable(false);

        // connectrequestsfield.setText("Connect requests:  " + "unknown ***********************************************");
        connectrequestsfield.setText("Connect requests:  " + "unknown");
        connectrequestsfield.setEditable(false);

        reconnectrequestsfield.setText("Connect requests:  " + "unknown");
        reconnectrequestsfield.setEditable(false);

        connectorprogramfield.setText("Connector program:  unknown");
        connectorprogramfield.setEditable(false);
        linestatusfield.setText("Line status:  unknown");
        linestatusfield.setEditable(false);
        informationfield.setText("Information:  ");
        informationfield.setEditable(false);
        myconnectfield.setText("This client:  ");
        myconnectfield.setEditable(false);


        clientspanel.add(clientcountfield);
        clientspanel.add(connectrequestsfield);
        clientspanel.add(reconnectrequestsfield);
        // clientspanel.setLayout(new GridLayout(1,3));
        // clientspanel.setLayout(new FlowLayout(FlowLayout.LEFT, 1,1));
        clientspanel.setLayout(new FlowLayout(FlowLayout.LEADING, 1,1));


        infopanel.add(isppanel);
        infopanel.add(commandpanel);

        infopanel.add(servernamefield);
        infopanel.add(clientspanel);
        infopanel.add(connectorprogramfield);
        infopanel.add(linestatusfield);
        infopanel.add(informationfield);
        infopanel.add(myconnectfield);

        infopanel.setLayout(new GridLayout(8,1));
        // infopanel.setLayout(new FlowLayout());





        infopanel.setBackground(Color.cyan);

        micef.add(infopanel);



        clientcountfield.setBackground(Color.lightGray);
        connectrequestsfield.setBackground(Color.lightGray);
        reconnectrequestsfield.setBackground(Color.lightGray);

        micef.pack();



        // micef.validate();

        // isppanel.validate();
        // commandpanel.validate();

        // isppanel.repaint();
        // commandpanel.repaint();

        micef.setVisible(true);

        // micef.invalidate();
        // quitbutton.invalidate();
    }


    // isp chooser
    public void itemStateChanged(ItemEvent ie) {
        final String GETISPS = "isps";
        // System.out.print(ie.getItem());
        // if 0 index is selected, ask server for a list of ISPs
        if (0 == ispChooser.getSelectedIndex()) {
            // printtoserver.println(GETISPS);   // don't want this
            disableConnect();  // disable the connection buttons if no ISP
        }
        else {
            // enable the connect buttons if ISP selected

            enableConnect();
            // don't disable chooser here
        }
        /*
         if (miceStatus.getMiceConsoleMode()) {
         System.out.println("item state change");
         }
         */
        micef.pack();
    }

    static void disableConnect() {
        // disable connection buttons
        connectbutton.setEnabled(false);
        connectbutton.setBackground(Color.white);
        connectbutton.setForeground(Color.blue);
        reconnectbutton.setEnabled(false);
        reconnectbutton.setBackground(Color.white);
        reconnectbutton.setForeground(Color.blue);
        // micef.pack();
    }

    static void enableChooser() {
        // enable the isp chooser
        ispChooser.setEnabled(true);
        ispChooser.setBackground(Color.blue);
        ispChooser.setForeground(Color.white);
        // micef.pack();
    }

    static void enableConnect() {
        // enable connection buttons
        connectbutton.setEnabled(true);
        connectbutton.setBackground(Color.blue);
        connectbutton.setForeground(Color.white);
        reconnectbutton.setEnabled(true);
        reconnectbutton.setBackground(Color.blue);
        reconnectbutton.setForeground(Color.white);
        // micef.pack();
    }

    static void disableChooser() {
        // disable the isp chooser
        ispChooser.setEnabled(false);
        ispChooser.setBackground(Color.white);
        ispChooser.setForeground(Color.blue);
        // micef.pack();
    }




    static public void setccfield(String f) {
        clientcountfield.setText(f);
        // if (miceStatus.getOsName().equalsIgnoreCase("epoc")) {
        // Psion doesn't reduce the field width
        // clientcountfield.setColumns(f.length());
        // clientcountfield.repaint();
        // }
        // Psion doesn't reduce the field width
        clientcountfield.setSize(clientcountfield.getMinimumSize());
        // clientcountfield.setSize(clientcountfield.getPreferredSize());

        // micef.pack();
    }
    static public void setcreqfield(String f) {
        connectrequestsfield.setText(f);
        // Psion doesn't reduce the field width
        connectrequestsfield.setSize(connectrequestsfield.getMinimumSize());
    }
    static public void setrcreqfield(String f) {
        reconnectrequestsfield.setText(f);
        // Psion doesn't reduce the field width
        reconnectrequestsfield.setSize(reconnectrequestsfield.getMinimumSize());
    }
    static public void setcpfield(String f, Color c) {
        connectorprogramfield.setText(f);
        connectorprogramfield.setBackground(c);
    }
    static public void setlinestatusfield(String f, Color c) {
        linestatusfield.setText(f);
        linestatusfield.setBackground(c);
    }
    static public void setinformationfield(String f, Color c) {
        informationfield.setText(f);
        informationfield.setBackground(c);
    }
    static public void setmyconnectfield(String f, Color c) {
        myconnectfield.setText(f);
        myconnectfield.setBackground(c);
    }
    static public void setservernamefield(String f) {
        servernamefield.setText(f);
    }
    // current isp
    static public void setCurrentIspShort(String f) {
        currentIspShort = f;
        /*
         if (miceStatus.getMiceConsoleMode()) {
         System.out.println("Current isp short set " + f);
         }
         */
    }
    // current isp
    static public void setCurrentIspLong(String f) {
        currentIspLong = f;
        /*
         if (miceStatus.getMiceConsoleMode()) {
         System.out.println("Current isp long set " + f);
         }
         */
        ispChooser.select(0);
        ispChooser.select(currentIspLong);
        if (0 != ispChooser.getSelectedIndex()) {
            enableConnect();  // enable the connection buttons
            disableChooser();
        }
        else {
            disableConnect();
            enableChooser();
        }
        // micef.pack();
    }


    static public void ResetIspChooser(String c [][]) {
        // this is run when isp data received from server
        ispData = c;  // copy the array of ispnames
        ispChooser.removeAll();
        for (int ctr = 0; ctr < ispData.length; ++ctr) {
            ispChooser.add(ispData[ctr][1]);
        }
        ispChooser.select(0);
        ispChooser.select(currentIspLong);

        // Psion doesn't increase the field width
        ispChooser.setSize(ispChooser.getMinimumSize());


        if (0 != ispChooser.getSelectedIndex()) {
            enableConnect();  // enable the connection buttons
            disableChooser();
        }
        else {
            disableConnect();  // disable the connection buttons if no ISP
            enableChooser();
        }
        // micef.pack();
    }


// }


    class myActionListener implements ActionListener {
        public void actionPerformed(ActionEvent ae) {
            /*
             if (miceStatus.getMiceConsoleMode()) {
             System.out.println("My action performed");
             System.out.println(String.valueOf(Userwindow.ispChooser.getSelectedIndex())
             + " "
             + Userwindow.ispChooser.getSelectedItem());
             System.out.println("ISP short is " + Userwindow.currentIspShort);
             }
             */
            if (("connect" == ae.getActionCommand())
                || ("reconnect" == ae.getActionCommand())) {
                // need to identify the isp short name.  Don't use the array in putmicedata
                // because it is another thread.  Use Userwindow variable.
                String ispShortChoice = "";
                for (int ctr = 0; ctr < Userwindow.ispData.length; ++ctr) {
                    // System.out.println("ISP longs are " + Userwindow.ispData[ctr][1]);
                    if (0 == Userwindow.ispData[ctr][1].compareTo(Userwindow.ispChooser.getSelectedItem())) {
                        ispShortChoice = Userwindow.ispData[ctr][0];
                        // System.out.println("chosen ISP short is " + ispShortChoice);
                        break;
                    }

                }
                Userwindow.printtoserver.println(ae.getActionCommand() + " "  + ispShortChoice);
            }
            else Userwindow.printtoserver.println(ae.getActionCommand());
        }
    }

    /*
     class myWindowListener extends WindowAdapter implements WindowListener {

     public void windowOpened(WindowEvent we) {
     ispChooser.requestFocus();
     }
     public void windowActivated(WindowEvent we) {
     ispChooser.requestFocus();
     }
     }
     */


}


// class errorWindow extends Component implements ActionListener {
class errorWindow extends KeyAdapter implements ActionListener, KeyListener {

    String errormsg;
    static Button errorbutton  = new Button("Quit");

    public errorWindow(String s) {
        errormsg = s;
        // System.out.println("in errorWindow " + errormsg);
        Label errorlabel = new Label(errormsg);
        Frame errorf = new Frame("Error.  Micej1 Client $Revision: 1.33 $");
        // quit on window close
        errorf.addWindowListener(new WindowAdapter()
                                 {
                                     public void windowOpened(WindowEvent we) {
                                         errorbutton.requestFocus();
                                     }
                                     public void windowActivated(WindowEvent we) {
                                         errorbutton.requestFocus();
                                     }
                                     public void windowClosing(WindowEvent we)
                                     {
                                         System.exit(0);
                                     }
                                 }
                                );
        // Container errorcontent = new Container();
        // errorf.add(errorcontent);
        errorf.setLayout(new FlowLayout());

        errorbutton.setBackground(Color.red);
        errorbutton.setForeground(Color.black);

        errorf.add(errorlabel);
        errorf.add(errorbutton);

        errorbutton.addActionListener(this);

        errorbutton.addKeyListener(this);

        errorf.pack();
        errorf.setVisible(true);
    }

    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == errorbutton) {
            // System.out.println("abort");
            System.exit(3);
        }
    }

    public void keyTyped(KeyEvent ke) {
        if ((ke.getSource() == errorbutton) && (ke.getKeyChar() == ke.VK_ENTER)) {
            System.exit(3);
        }
    }
}


class miceStatus {
    static boolean micemodegraphic = true, micemodeconsole = false;  // default
    static String myOsName = "unknown";
    public miceStatus(String s) {
        String micemode = s;
        if (micemode.equalsIgnoreCase("console")) {
            micemodeconsole = true;
            micemodegraphic = false;
        }
        else if (micemode.equalsIgnoreCase("both")) {
            micemodeconsole = true;
            micemodegraphic = true;
        }
        else {
            micemodeconsole = false;
            micemodegraphic = true;
        }
        // Get the OS name.  The Psion 5mx has problems with socket linger
        try {
            myOsName = System.getProperty("os.name", "unknown");
        }
        catch(Exception e) {
            // Don't worry about it, use default of unknown
            myOsName = "unknown";
        }
    }

    public static boolean getMiceConsoleMode() {
        return micemodeconsole;
    }

    public static boolean getMiceGraphicMode() {
        return micemodegraphic;
    }

    public static void showError(String es) {
        if (micemodeconsole) {
            System.out.println(es);
        }
        if (micemodegraphic) {
            new errorWindow(es);
        }
    }

    public static String getOsName() {
        return myOsName;
    }
}


// class chooserWindow extends Component KeyAdapter implements ActionListener, KeyListener {
class chooserWindow extends KeyAdapter implements ActionListener, KeyListener {

    // String errormsg;
    static Button errorbutton  = new Button("Quit");
    static Button okbutton  = new Button("OK");
    static String host;
    static String port;
    TextField hostfield = new TextField();
    TextField portfield = new TextField();
    Label hostlabel = new Label();
    Label portlabel = new Label();
    Frame chooserf = new Frame("Choose Host.  Micej1 Client $Revision: 1.33 $");
    Panel hostpanel = new Panel();
    Panel portpanel = new Panel();
    Panel buttonpanel = new Panel();

    myWindowListener mwl = new myWindowListener();
    myMouseListener mml = new myMouseListener();


    public chooserWindow(String h, int p) {
        host = h;
        port = String.valueOf(p);
        // errormsg = s;
        // System.out.println("in errorWindow " + errormsg);
        // Label chooserlabel = new Label("Choose server");
        // quit on window close
        chooserf.addWindowListener(mwl);

        /*
        chooserf.addWindowListener(new WindowAdapter()
                                   {
                                       public void windowClosing(WindowEvent we)
                                       {
                                           System.exit(0);
                                       }
                                   }
                                  );
        */
        // chooserf.setLayout(new FlowLayout());
        // chooserf.setLayout(new GridLayout(4,1));

        // hostfield.setText("Host goes here");
        hostfield.setText(host);
        hostfield.setEditable(true);
        // hostfield.setColumns(host.length() + host.length() /2);
        hostfield.setColumns(30);
        hostlabel.setText("Host");
        portfield.setText(port);
        portfield.setEditable(true);
        portfield.setColumns(6);
        portlabel.setText("Port");

        okbutton.setBackground(Color.green);
        okbutton.setForeground(Color.black);
        errorbutton.setBackground(Color.red);
        errorbutton.setForeground(Color.black);

        hostpanel.add(hostlabel);
        hostpanel.add(hostfield);
        // hostpanel.setLayout(new GridLayout(1,2));
        hostpanel.setLayout(new FlowLayout(FlowLayout.LEFT, 1,1));
        portpanel.add(portlabel);
        portpanel.add(portfield);
        // portpanel.setLayout(new GridLayout(1,2));
        portpanel.setLayout(new FlowLayout(FlowLayout.LEFT, 1,1));
        buttonpanel.add(okbutton);
        buttonpanel.add(errorbutton);
        buttonpanel.setLayout(new FlowLayout(FlowLayout.CENTER));
        chooserf.add(hostpanel);
        chooserf.add(portpanel);
        chooserf.add(buttonpanel);
        chooserf.setLayout(new GridLayout(3,1));
        // chooserf.setLayout(new FlowLayout(FlowLayout.LEFT, 1,1));


        okbutton.addActionListener(this);
        errorbutton.addActionListener(this);

        // hostfield.addActionListener(this);
        // portfield.addActionListener(this);

        okbutton.addKeyListener(this);
        errorbutton.addKeyListener(this);
        hostfield.addKeyListener(this);
        portfield.addKeyListener(this);

        okbutton.addMouseMotionListener(mml);
        errorbutton.addMouseMotionListener(mml);
        hostfield.addMouseMotionListener(mml);
        portfield.addMouseMotionListener(mml);

        // hostfield.requestFocus();
        // chooserf.requestFocus();


        chooserf.pack();
        chooserf.setVisible(true);
    }

    public void actionPerformed(ActionEvent ae) {
        // if (ae.getSource() == okbutton) {
        if ((ae.getSource() == okbutton)
            ||  (ae.getSource() == hostfield)
            ||  (ae.getSource() == portfield)) {
            // System.out.println("abort");
            micej1.host = hostfield.getText();
            micej1.port = Integer.parseInt(portfield.getText());
            if (miceStatus.getMiceConsoleMode()) {
                System.out.println("New host name: " + micej1.host);
                System.out.println("New port: " + micej1.port);
            }
            micej1.doConnect();
            chooserf.dispose();
            // System.exit(3);
        }
        else if (ae.getSource() == errorbutton) {
            // System.out.println("abort");
            System.exit(3);
        }
    }

    public void keyTyped(KeyEvent ke) {
        // if (ke.getSource() == okbutton) {
        // if (ke.getKeyChar() == 'a') {
        if ((ke.getSource() == okbutton)
            ||  (ke.getSource() == hostfield)
            ||  (ke.getSource() == portfield)) {
            if (ke.getKeyChar() == ke.VK_ENTER) {

                micej1.host = hostfield.getText();
                micej1.port = Integer.parseInt(portfield.getText());
                if (miceStatus.getMiceConsoleMode()) {
                    System.out.println("New host name: " + micej1.host);
                    System.out.println("New port: " + micej1.port);
                }
                micej1.doConnect();
                chooserf.dispose();
            }
        }
        else if (ke.getSource() == errorbutton) {
            if (ke.getKeyChar() == ke.VK_ENTER) {
                System.exit(3);
            }
        }
    }



    class myWindowListener extends WindowAdapter implements WindowListener {
        public void windowOpened(WindowEvent we) {
            hostfield.requestFocus();
        }
        public void windowActivated(WindowEvent we) {
            hostfield.requestFocus();
        }
        public void windowClosing(WindowEvent we)
        {
            System.exit(0);
        }
    }

    class myMouseListener extends MouseMotionAdapter implements MouseMotionListener {
        public void mouseMoved(MouseEvent me) {
            Component msource = (Component)me.getSource();
            //if (me.getSource() == okbutton) {
                // okbutton.requestFocus();
                // okbutton.requestFocus();
                // me.getsource().requestFocus();
                // msource.requestFocus();
            //}
            msource.requestFocus();

        }
    }
}

